/*
 * Decompiled with CFR 0.152.
 */
package limbo.pcc.pcc_limbo_system.task;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import limbo.pcc.pcc_limbo_system.Pcc_limbo_system;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ChatCommandExecutor
implements CommandExecutor {
    Plugin config = Pcc_limbo_system.getProvidingPlugin(Pcc_limbo_system.class);
    private final OkHttpClient httpClient;
    private final String apiEndpoint = this.config.getConfig().getString("ip");
    private final String defaultUid = "console";
    private final Map<String, List<JsonObject>> conversationHistories = new HashMap<String, List<JsonObject>>();

    public ChatCommandExecutor() {
        this.httpClient = new OkHttpClient.Builder().callTimeout(40L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).writeTimeout(60L, TimeUnit.SECONDS).build();
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        List<JsonObject> conversation;
        String lastArg;
        JavaPlugin config = Pcc_limbo_system.getProvidingPlugin(Pcc_limbo_system.class);
        if (!sender.hasPermission("pcc.command.chat")) {
            sender.sendMessage(ChatColor.RED + "\u4f60\u6ca1\u6709\u4f7f\u7528\u8be5\u529f\u80fd\u7684\u6743\u9650");
            return false;
        }
        if (args.length < 1) {
            sender.sendMessage(ChatColor.RED + "\u4f7f\u7528\u65b9\u6cd5\uff1a/chat [\u4f60\u8981\u8bf4\u7684\u8bdd] [\u6a21\u578b\u9009\u62e9 (\u53ef\u9009: gpt-4o/gpt-4o-mini)]");
            sender.sendMessage(ChatColor.RED + "\u6216\u8005\u4f7f\u7528 /chat clear \u6765\u6e05\u9664\u4f1a\u8bdd");
            return false;
        }
        String modelChoice = "gpt-4o";
        String uid = sender instanceof Player ? ((Player)sender).getUniqueId().toString() : "console";
        if (args.length == 1 && args[0].equalsIgnoreCase("clear")) {
            this.conversationHistories.remove(uid);
            sender.sendMessage(ChatColor.GREEN + "\u4f60\u7684\u4f1a\u8bdd\u5df2\u88ab\u6e05\u9664\u3002");
            return true;
        }
        sender.sendMessage(ChatColor.YELLOW + "\u7b49\u5f85\u540e\u7aef\u670d\u52a1\u5668\u56de\u5e94\uff0c\u8bf7\u7a0d\u7b49");
        String message = String.join((CharSequence)" ", args);
        if (args.length > 1 && ((lastArg = args[args.length - 1]).equalsIgnoreCase("gpt-4o") || lastArg.equalsIgnoreCase("gpt-4o-mini"))) {
            modelChoice = lastArg;
            message = String.join((CharSequence)" ", Arrays.copyOfRange(args, 0, args.length - 1));
        }
        if ((conversation = (List<JsonObject>)this.conversationHistories.getOrDefault(uid, new ArrayList())).isEmpty()) {
            JsonObject systemMessage = new JsonObject();
            systemMessage.addProperty("role", "system");
            systemMessage.addProperty("content", config.getConfig().getString("prompt"));
            conversation.add(systemMessage);
        }
        JsonObject userMessage = new JsonObject();
        userMessage.addProperty("role", "user");
        userMessage.addProperty("content", message);
        conversation.add(userMessage);
        if (conversation.size() > 20) {
            conversation = conversation.subList(conversation.size() - 20, conversation.size());
        }
        this.conversationHistories.put(uid, conversation);
        MediaType mediaType = MediaType.parse((String)"application/json");
        JsonObject jsonBody = new JsonObject();
        jsonBody.add("messages", (JsonElement)new Gson().toJsonTree(conversation).getAsJsonArray());
        jsonBody.addProperty("modelChoice", modelChoice);
        RequestBody body = RequestBody.create((String)jsonBody.toString(), (MediaType)mediaType);
        Request request = new Request.Builder().url(this.apiEndpoint).post(body).build();
        List<JsonObject> finalConversation = conversation;
        new Thread(() -> this.lambda$onCommand$0(request, sender, (Plugin)config, finalConversation, uid)).start();
        return true;
    }

    private /* synthetic */ void lambda$onCommand$0(Request request, CommandSender sender, Plugin config, List finalConversation, String uid) {
        JsonObject jsonResponse;
        String responseBody;
        Response response;
        try {
            Call call = this.httpClient.newCall(request);
            response = call.execute();
        }
        catch (IOException e) {
            sender.sendMessage(ChatColor.RED + "\u4e0e\u804a\u5929\u673a\u5668\u4eba\u901a\u4fe1\u65f6\u53d1\u751f\u7f51\u7edc\u9519\u8bef\uff01");
            e.printStackTrace();
            return;
        }
        try {
            responseBody = Objects.requireNonNull(response.body()).string();
            config.getLogger().info("Response Body: " + responseBody);
        }
        catch (IOException e) {
            sender.sendMessage(ChatColor.RED + "\u8bfb\u53d6\u804a\u5929\u673a\u5668\u4eba\u54cd\u5e94\u65f6\u53d1\u751f\u9519\u8bef\uff01");
            e.printStackTrace();
            return;
        }
        try {
            jsonResponse = (JsonObject)new Gson().fromJson(responseBody, JsonObject.class);
        }
        catch (JsonSyntaxException e) {
            sender.sendMessage(ChatColor.RED + "\u89e3\u6790\u804a\u5929\u673a\u5668\u4eba\u54cd\u5e94\u65f6\u53d1\u751f\u9519\u8bef\uff1a\u65e0\u6548\u7684JSON\u683c\u5f0f\uff01");
            e.printStackTrace();
            return;
        }
        if (jsonResponse.has("error")) {
            String errorMessage = jsonResponse.get("error").getAsString();
            sender.sendMessage(ChatColor.RED + "\u670d\u52a1\u5668\u9519\u8bef\uff1a" + errorMessage);
            config.getLogger().warning("Server error: " + errorMessage);
            return;
        }
        JsonElement replyElement = jsonResponse.get("reply");
        if (replyElement == null || replyElement.isJsonNull()) {
            sender.sendMessage(ChatColor.RED + "\u804a\u5929\u673a\u5668\u4eba\u54cd\u5e94\u4e2d\u7f3a\u5c11 'reply' \u5b57\u6bb5\uff01");
            config.getLogger().warning("Missing 'reply' field in response: " + responseBody);
            return;
        }
        String responseText = replyElement.getAsString();
        JsonObject aiMessage = new JsonObject();
        aiMessage.addProperty("role", "assistant");
        aiMessage.addProperty("content", responseText);
        finalConversation.add(aiMessage);
        this.conversationHistories.put(uid, finalConversation);
        sender.sendMessage(ChatColor.GREEN + "[\u804a\u5929\u673a\u5668\u4eba] " + ChatColor.WHITE + responseText);
        config.getLogger().info(responseText);
        if (responseText.contains("gpt-4o-mini")) {
            sender.sendMessage(ChatColor.YELLOW + "[\u6ce8\u610f]: \u6a21\u578b\u5df2\u5207\u6362\u5230 gpt-4o-mini \u7531\u4e8e gpt-4o \u8fbe\u5230\u9650\u989d");
            config.getLogger().info("[\u6ce8\u610f]: \u6a21\u578b\u5df2\u5207\u6362\u5230 gpt-4o-mini \u7531\u4e8e gpt-4o \u8fbe\u5230\u9650\u989d");
        }
    }
}

